/******************************************************************************
 * @file: grl_font.h
 *
 * @version: $Id: grl_font.h,v 1.16 2010/11/18 14:13:16 efriedrich Exp $
 *
 * @component:  header file for helper functions for svg_font library
 *
 * @author:
 *
 * @copyright: (c) 2003 - 2006 ADIT Corporation
 *
 * @history
 ******************************************************************************/
#ifndef __GRL_FONT_H__
#define __GRL_FONT_H__

#include <svg_typedef.h>
#include <svg_font.h>
#include <svg_font_config.h>
#include "grl_dlt_log.h"


/* flashfonts filenames looks:
 *
 *    /flashfont/SSSS/LLLL
 *
 *    SSSS = 32-Bit start address
 *    LLLL = 32-Bit length of font
 */
#define FF_ROOT         "/flashfont/"
#define FF_ROOT_LEN     11
#define FF_INTEGER_LEN  4
#define FF_NAME_LENGTH  27
#define FF_SLASH        "/"


/* suffix list is .sss\t etc. */
#define SUFFIX_LENGTH   5

#define SVG_MAX_PATH    256


/* defines for rotation */
#define MIN_ANGLE   -360.0f
#define MAX_ANGLE   360.0f

/*should be a prime number because it will be used for hash value calculation*/
#define MAX_CACHE_ENTRIES 53

/* How many entries should be deleted from cache in case it is full
 * PERCENT INDICATION!!!*/
#define CACHE_CLEANUP_RATIO 20

#define UNREFED_FONT_PARAM(arg) arg = arg;

typedef struct SVGMemoryRec_*  Memory;
typedef void*  (*Alloc_Func)(Memory  memory, SVGUint32 size );
typedef void   (*Free_Func) (Memory  memory, void* block );
typedef void*  (*Realloc_Func)(Memory  memory, SVGUint32 cur_size, SVGUint32 new_size, void* block );
struct  SVGMemoryRec_
  {
    void*         svguser;
    Alloc_Func    svgalloc;
    Free_Func     svgfree;
    Realloc_Func  svgrealloc;
  };

/*
  *  If application does not need shaping engine to process any particular complex scripts,
  * those complex scripts should be added to SVG_SHPENG_NOTNEED_LANGLIST in svg_config file and HB engine will not be enabled
  * for those scripts.
  * SVG_SHPENG_NOTNEED_LANGLIST=arab hebr
  *
  * Refered link for unicode range:
  * http://jrgraphix.net/research/unicode_blocks.php
  * https://www.terena.org/activities/multiling/ml-docs/iso-8859.html
  *
  *  later will add the below complex scripts list if required to support
  * Greek,Hangul,Khmer,Ogham,Myanmar,indic langauges
  */
 /*                           UNICODE RANGE,SCRIPT,      SVG_SCRIPT ,            SVG_RENDER_DIRECTION, ENABLE FLAG */
#define SUPPORTED_COMPLEX_SCRIPTS_LIST                                                                                                                                       \
                            { 0X0E00,0X0E7F,      "Thai", SVG_SCRIPT_THAI, SVG_RENDER_DIRECTION_LTR,SVG_TRUE,{0}},      \
                            {0X0600,0X06FF,       "Arab", SVG_SCRIPT_ARABIC, SVG_RENDER_DIRECTION_RTL,SVG_TRUE,{0}},   \
                            { 0,0,NULL,SVG_TAG_NONE,SVG_RENDER_DIRECTION_INVALID,SVG_FALSE,{0}}

/*
 * TODO : collect information about diacritical glyphs ranges , symbols & extended glyphs ranges
 * prepare correct simple scripts list.
*/
#define SUPPORTED_SIMPLE_SCRIPTS_LIST          \
                                                       {0x0020,0x058F},    \
                                                       {0X1E00,0XFB4F} ,\
                                                       {0XFE00,0XFE6F}, \
                                                       {0XFF00,0XFFFF}, \
                                                       {0,0}
/**
 * This structure has the information about the language/script
 * unicode ranges,render direction and enabled flag
 */
typedef struct scriptlist
{
    SVGUint32  unicode_start;
    SVGUint32  unicode_end;
     SVGChar  *scriptname;
    SVGUint32 script_tag;
    SVGUint32 rendr_direc_tag;
    /* if enabled, then only Shaping process will be taken care*/
    SVGChar   flag;
    SVGChar  Reserved[3];
}Complex_Scripts_List;

typedef struct simplelist
{
    SVGUint32  unicode_start;
    SVGUint32  unicode_end;
}Simple_Scripts_List;

typedef struct autolangdb
{
    Complex_Scripts_List *p_complxscriptlist;
    Simple_Scripts_List     *p_simplescriptlist;
    SVGBoolean autolangdetect;
    SVGChar Reserved[3];
}AUTOLANG_DB;

/* Dlt specific variables for ctx and debug level */
extern SVGUint8 grl_sfnt_debugLevel;
extern void *grl_sfnt_dlt_ctx;

/* Macros exported to svg font for dlt tracing */
#define SVG_FNT_F(args...) SVG_DLT_F(grl_sfnt_dlt_ctx, grl_sfnt_debugLevel, args)
#define SVG_FNT_E(args...) SVG_DLT_E(grl_sfnt_dlt_ctx, grl_sfnt_debugLevel, args)
#define SVG_FNT_W(args...) SVG_DLT_W(grl_sfnt_dlt_ctx, grl_sfnt_debugLevel, args)
#define SVG_FNT_U(args...) SVG_DLT_U(grl_sfnt_dlt_ctx, grl_sfnt_debugLevel, args)
#define SVG_FNT_D(args...) SVG_DLT_D(grl_sfnt_dlt_ctx, grl_sfnt_debugLevel, args)


/**
 * @param  gp_SVG_beginModuleInfoList
 *
 * Global value defined in svg_font.c.
 */
extern grl_module_info_list    *gp_SVG_beginModuleInfoList;

/**
 * @fn GRL_buildup_font_database
 *
 * buildup the font database
 *
 * @return TRUE or FALSE
 */
SVGBoolean GRL_buildup_font_database( void );


/**
 * @fn GRL_update_fonts
 *
 * update the font database
 *
 * @return TRUE or FALSE
 */
void GRL_update_fonts(void);


/**
 * @fn GRL_get_font_id
 *
 * searching in the context attached font module after the given font
 * information and returns the intern address of the font
 *
 * @param SVGFontContext        : Pointer to the font context
 * @param SVGFont*              : Pointer to the sought font pointer
 *
 * @return SVGFont*             : Intern address of the font,
 *                                if isn't available returns NULL
 *
 */
SVGFont* GRL_get_font_id( SVGFontContext* ctx,
                          SVGFont* p_font );


/**
 * @fn GRL_get_next_module_info
 *
 * get the next module information
 *
 * @param grl_module_info           : Inherid valid module information
 *
 * @return TRUE or FALSE
 *
 * NOTE:  The function begins at the top of the list. If the return value
 *        is FALSE p_module_info is empty and the function reaches the end.
 *        At the next call the function begin again at the top.
 */
SVGBoolean GRL_get_next_module_info( grl_module_info** pp_module_info );

#endif /* __GRL_FONT_H__ */
